/*
 * Decompiled with CFR 0.152.
 */
package util;

import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Date;
import util.SerializableTest;

public class ClassInspector {
    protected static final String dashes = "-----------------------------------------------";

    public static String _get_FILE_DATE() {
        return "$Date:   25 Aug 2008 16:03:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.12  $";
    }

    protected static final void printVersion(Class theClass) {
        try {
            String[] methodNames = new String[]{"_get_FILE_REVISION", "_get_FILE_AUTHOR", "_get_FILE_DATE"};
            for (int j = 0; j < methodNames.length; ++j) {
                try {
                    Method method = theClass.getMethod(methodNames[j], null);
                    String res = (String)method.invoke(null, null);
                    System.out.println("\t" + res);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static final void printCtors(Class theCls) {
        try {
            Constructor<?>[] ctors = theCls.getConstructors();
            int nMethods = ctors == null ? 0 : ctors.length;
            System.out.println("Found " + nMethods + " constructor(s)..............");
            for (int j = 0; j < nMethods; ++j) {
                System.out.println("\t" + ctors[j]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static final void printMethods(Class theCls) {
        try {
            Method[] publicMethods = theCls.getMethods();
            int nMethods = publicMethods == null ? 0 : publicMethods.length;
            System.out.println("Found " + nMethods + " public methods.................");
            for (int j = 0; j < nMethods; ++j) {
                System.out.println("\t" + publicMethods[j]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static final void printInterfaces(Class theCls) {
        try {
            Class<?>[] interfaces = theCls.getInterfaces();
            int nInterfaces = interfaces == null ? 0 : interfaces.length;
            System.out.println("Implements " + nInterfaces + " interfaces.");
            for (int j = 0; j < nInterfaces; ++j) {
                System.out.println(interfaces[j]);
            }
            Class theSuperCls = theCls.getSuperclass();
            if (theSuperCls != null) {
                System.out.println("Getting superclass " + theSuperCls.getName());
                ClassInspector.printInterfaces(theSuperCls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("ClassInspector [/v] [/m] [/c] [/i] [/s] [/qi <interfacename>] [/h] [/?] classname classname");
        System.out.println("   /m:  print public methods of the class.");
        System.out.println("   /c:  print construtors of the class.");
        System.out.println("   /i:  print interfaces that class implemented.");
        System.out.println("   /qi <interfacename>: query to see if the class implemented the interface.. directly or via a superclass.");
        System.out.println("   /v:  print PVCS-related stuff for the class");
        System.out.println("   /s:  print the serializable member variables recursively");
        System.out.println("   /h, /?:  this message.");
    }

    public static void main(String[] args) {
        VWCommandLineArgs c;
        int nArgs;
        int n = nArgs = args == null ? 0 : args.length;
        if (nArgs == 0) {
            System.exit(0);
        }
        if ((c = new VWCommandLineArgs(args)).isPresent("h") || c.isPresent("?")) {
            ClassInspector.printUsage();
            System.exit(0);
        }
        boolean printMethod = c.isPresent("m");
        boolean printVersion = c.isPresent("v");
        boolean printCtor = c.isPresent("c");
        boolean printInterfaces = c.isPresent("i");
        boolean printSerializable = c.isPresent("s");
        String queryInterface = c.getParameter("qi");
        for (int i = 0; i < nArgs; ++i) {
            if (args[i].equals("/v") || args[i].equals("/m") || args[i].equals("/i") || args[i].equals("/c") || args[i].equals("/s")) continue;
            if (args[i].equals("/qi")) {
                ++i;
                continue;
            }
            try {
                System.out.println(dashes);
                System.out.println(new Date().toString());
                String className = ClassInspector.getClassName(args, i);
                System.out.println("Class  " + className);
                System.out.println("location = " + ClassInspector.getClassLoc(className));
                System.out.println(dashes);
                Class<?> theCls = Class.forName(className);
                if (printInterfaces) {
                    ClassInspector.printInterfaces(theCls);
                }
                if (printCtor) {
                    ClassInspector.printCtors(theCls);
                }
                if (printMethod) {
                    ClassInspector.printMethods(theCls);
                }
                if (printVersion) {
                    ClassInspector.printVersion(theCls);
                }
                if (queryInterface != null) {
                    ClassInspector.checkInterface(theCls, queryInterface);
                }
                if (printSerializable) {
                    SerializableTest test = new SerializableTest(className);
                    test.inspect();
                }
                System.out.println(dashes);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static String getClassName(String[] args, int i) {
        int kk;
        String s = args[i].trim();
        if (s.endsWith(".class")) {
            kk = s.lastIndexOf(".class");
            s = s.substring(0, kk);
        } else if (s.endsWith(".java")) {
            kk = s.lastIndexOf(".java");
            s = s.substring(0, kk);
        }
        String className = s.replace(File.separatorChar, '.');
        return className;
    }

    public static String getClassLoc(String className) {
        Object error = null;
        String classLocation = null;
        String classLoaderInfo = null;
        if (className != null && (className = className.trim()).length() != 0) {
            try {
                ProtectionDomain pd = Class.forName(className).getProtectionDomain();
                if (pd != null) {
                    CodeSource cs = pd.getCodeSource();
                    classLocation = cs != null ? cs.toString() : "No CodeSource found!";
                    classLoaderInfo = Class.forName(className).getClassLoader().toString();
                } else {
                    classLocation = "No ProtectionDomain found!";
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return classLocation;
    }

    protected static final void checkInterface(Class thisCls, String iName) {
        try {
            Class theCls = thisCls;
            boolean found = false;
            while (theCls != null && !found) {
                Class<?>[] interfaces = theCls.getInterfaces();
                int nInterfaces = interfaces == null ? 0 : interfaces.length;
                for (int j = 0; j < nInterfaces; ++j) {
                    String iFromClassName = interfaces[j].getName();
                    int loc = iFromClassName.indexOf(iName);
                    if (loc < 0 || loc + iName.length() != iFromClassName.length()) continue;
                    found = true;
                    System.out.println(thisCls.getName() + " implements " + iName + " in " + theCls.getName());
                }
                if (found) continue;
                theCls = theCls.getSuperclass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

